VERSION 5.00
Begin VB.Form SecureServer 
   Caption         =   "Secure Server"
   ClientHeight    =   4485
   ClientLeft      =   -14565
   ClientTop       =   7275
   ClientWidth     =   6150
   LinkTopic       =   "Form1"
   ScaleHeight     =   4485
   ScaleWidth      =   6150
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox Text1 
      Height          =   1005
      Left            =   1320
      MultiLine       =   -1  'True
      TabIndex        =   3
      Text            =   "Secure Server.frx":0000
      Top             =   3360
      Width           =   4695
   End
   Begin VB.Label Label4 
      Caption         =   $"Secure Server.frx":0009
      Height          =   855
      Left            =   240
      TabIndex        =   4
      Top             =   2280
      Width           =   5775
   End
   Begin VB.Label Label3 
      Caption         =   "Last User:"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   3360
      Width           =   975
   End
   Begin VB.Label Label2 
      Caption         =   $"Secure Server.frx":00FD
      Height          =   1095
      Left            =   240
      TabIndex        =   1
      Top             =   1080
      Width           =   5775
   End
   Begin VB.Label Label1 
      Caption         =   $"Secure Server.frx":021B
      Height          =   975
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   5775
   End
End
Attribute VB_Name = "SecureServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim MyCert As Certificate, MasterCert As Certificate
Dim WithEvents Server As DicomServer
Attribute Server.VB_VarHelpID = -1

Private Sub Form_Load()
    ' First load the certificates we use
    
    ' Note that MyCert must have a private key, but that MasterCert need not
    Set MyCert = New Certificate
    MyCert.Load App.Path & "\dicomserver.pfx"
    Set MasterCert = New Certificate
    MasterCert.Load App.Path & "\master.cer"

    If Not MyCert.HasPrivateKey Then
        MsgBox "Server certificate (MyCert) MUST have an accessible private key"
        End
    End If
    
    ' Create Server and Listen on chosen ports
    Set Server = New DicomServer
    Server.ListenSecure 2762, MyCert, True
    Server.ListenSecure 2763, MyCert, False
    
    Dim g As New DicomGlobal
    Me.Caption = Me.Caption & " DicomObjects v" & g.Version
End Sub

Private Sub Server_AssociationRequest(ByVal Connection As DicomObjects8.DicomConnection, isOK As Boolean)
    Dim cert As Certificate
    ' if port is 2763 then we accept anything
    If Connection.LocalPort = 2763 Then
        Text1 = "Non-authenicated user accepted on port 2763"
        Exit Sub
    End If
    
    ' Otherwise verify client certificate
    Set cert = Connection.RemoteCertificate
    
    ' The "Simple" way to do this would be to use
    ' cert.IsValid but this would be checking against a generic list of trusted
    ' roots, so ANYONE with a Verisgn issued certificate would pass!
    
    ' Instead, here, we assume a simplistic hospital PKI system,
    ' and simply check that the root certificate is the correct Master root
    ' Other customs OIDs etc would be checked in a real application to verifiy
    ' the user's role etc.
    
    Dim CertChain As New Chain
    CertChain.Build cert ' this now contains full chain back to the root
    
    If CertChain.Certificates(CertChain.Certificates.Count).Thumbprint = MasterCert.Thumbprint Then
        'We are OK - note user name and allow connection
        Text1 = cert.SubjectName & " - Accepted"
        isOK = True
    Else
        ' Fail
        Text1 = cert.SubjectName & " - Failed"
        isOK = False
    End If
End Sub
